Attribute VB_Name = "normalPlane"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


'Visual Basic Exaple to create a Workplane perpendicular to a given line and
'at a location specified by the parameter

Dim app As ProDESKTOP
Dim part As PartDocument
Dim workplaneName As String
Dim sketchName As String
Dim bNoSketch As Boolean
Dim color As Integer
Dim line As aLine
Dim param As Double

Sub NormalPlaneExample()

Call SetDataForNormalPlane
NormalPlane line, param, workplaneName, sketchName, bNoSketch, color

End Sub

Private Function SetDataForNormalPlane()

    'Set the data for the Normal Plane
          
    'Get the ProDESKTOP Application Object
    Set app = CreateObject("ProDESKTOP.Application")
    
    If app Is Nothing Then        'Exit if no ProDESKTOP Application Object is created.
        MsgBox ("Could not create the ProDESKTOP Application Object")
        Exit Function
    End If
    
    app.SetVisible (True)
    Set part = app.NewPart()
    
    If part Is Nothing Then                         'Exit if no Part document is active
        MsgBox ("Could not get the Part Object")
        Exit Function
    End If
    
	'Create a VectorClass
	dim vecCls as VectorClass
	set vecCls = app.GetClass("Vector")

	'Create a BasicStraightClass
	dim basicStrCls as BasicStraightClass
	set basicStrCls = app.GetClass("BasicStraight")

    'Create a Line to which a Normal Plane will be created.
    Dim vector1 As ZVector
    Dim vector2 As ZVector
    Dim curve As zCurve
    Dim Sketch As aSketch
    Set vector1 = vecCls.CreateVector(0, 0, 0#)
    Set vector2 = vecCls.CreateVector(0.1, 0.1, 0#)
    Set curve = basicStrCls.CreateBasicStraightTwoPoints(vector1, vector2)
    Set Sketch = part.GetActiveSketch()
    Set line = Sketch.CreateLine(curve)
        
    Let param = 0.5
    workplaneName = "NormalPlane"
    sketchName = "sketchNormalPlane"
    bNoSketch = False
    color = 2
    
End Function

private Function NormalPlane(line As aLine, param As Double, workplaneName As String, sketchName As String, bNoSketch As Boolean, color As Integer)

'Subroutine to create a Workplane perpendicular to a given line and
'at a location specified by the parameter

'Creates a Workplane in the Active Design with the given name.
'One must create and select a Straight line to create this workplane.
'The workplane is created containing a single sketch which is set as active sketch
'The color of the sketch is set using the given value of the color parameter.

If line Is Nothing Then                     'Exit if line is not present
    MsgBox ("Please Create a Line")
    Exit Function
Else
    Dim blnLine As Boolean                  'Check if the line is of type ALine
    blnLine = line.IsA("Line")
End If

If blnLine Then

    'Define variable used to hold the ProDESKTOP object
    Dim app As Object
    'Define variable used to hold the PartDocument object
    Dim part As PartDocument
    'Define variable used to hold the Design object
    Dim design As ADesign
    
    Const pause As Boolean = False

    'Connect to the ProDESKTOP Application object.
    Set app = GetObject("", "ProDESKTOP.Application")
    
    'Exit if no ProDESKTOP Application Object is created.
    If app Is Nothing Then
        MsgBox ("Could not create the ProDESKTOP Application Object")
        Exit Function
    End If

    Dim api As helm
    Set api = app.TakeHelm

    'Get the active part document
    Set part = app.GetActiveDoc()

    'Exit if no Part document is active
    If part Is Nothing Then
        MsgBox ("Could not get the Part Object")
        Exit Function
    End If
     
    'Get the Design
    Set design = part.GetDesign
    
    'Get the geometry of the line
    Dim curve As zGeometry
    Set curve = line.GetGeometry
    
    'Check if the curve obtained is of type zStraight
    Dim bIsStraight As Boolean
    bIsStraight = curve.IsA("straight")
      
    'Exit if not straight
    If bIsStraight Then
    
        'Set the curve to zStraight
        Dim lineStraight As ZStraight
        Set lineStraight = curve
        
        Dim startPoint As ZVector
        Dim endPoint As ZVector
        Dim midpoint As ZVector
        
        'Get the Start and End Point of the line curve
        Set startPoint = lineStraight.GetStart
        Set endPoint = lineStraight.GetEnd
        
        'Get the Midpoint using the specified Parameter
        Dim offsetVector As ZVector
        Set offsetVector = endPoint.subtract(startPoint).Multiply(param)
        Set midpoint = startPoint.Add(offsetVector)
                
        'Get the Vector from the start and end points
        Dim vec As ZVector
        Set vec = endPoint.subtract(startPoint)
        
		'Create a DirectionClass
		Dim dirCls as DirectionClass
		set dirCls = app.GetClass("Direction")

        'Create a direction from the vector
        Dim dir As zDirection
        Set dir = dirCls.CreateDirection(vec.GetAt(0), vec.GetAt(1), vec.GetAt(2))
            
    Else
        Exit Function
    End If
        
    'Create a DirectionClass
	Dim basicPlaneCls as BasicPlaneClass
	set basicPlaneCls = app.GetClass("BasicPlane")

    'Create a Basicplane using the midpoint and the direction of the line
    Dim plane As zBasicPlane
    Set plane = basicPlaneCls.CreateBasicPlane(midpoint, dir)
    
    'Create a Workplane using the Basicplane and the workplane name
    Set NormalPlane = design.CreateWorkplane(plane, workplaneName)
    
	'Create a MatrixClass
	dim matrixCls as MatrixClass
	set matrixCls = app.GetClass("Matrix")
	  
    'Create an idendity matrix
    Dim identity As zMatrix
    Set identity = matrixCls.CreateScaleMatrix(1)

    'Create a bounding box
    Dim box As zBox
    Set box = plane.GetBoundingBox(identity)
    bIsEmpty = box.IsEmpty()
    
    'Set the local origin of the normal plane to the center of the box
    If Not bIsEmpty Then
        NormalPlane.SetLocalOrigin box.GetCenter
    End If
         
    'Proceed if the boolean for the bNoSketch is false
    If Not bNoSketch Then
    
        'Create a sketch using the Sketch Name
        Dim NormalPlaneSketch As aSketch
        Set NormalPlaneSketch = NormalPlane.CreateSketch(sketchName)
        
        'Set the value of color to 4 if the value of color is not between 0 and 11
        If color < 0 Or color > 11 Then
            color = 4
        End If
        
		'Create a ColorClass
		Dim colorCls as ColorClass
		set colorCls = app.GetClass("Color")

        'Create a color using the value of color
        Dim newColor As zColor
        Set newColor = colorCls.CreateColor(1, color * 30, 0.35, 1)
        
        'Set the color for the lines using the newColor
        NormalPlaneSketch.SetColor newColor
        
        'Set the active sketch to the NormalPlaneSketch.
        part.SetActiveSketch NormalPlaneSketch
            
    End If
    
End If

api.CommitCalls "Create Normal Plane", pause

End Function


